unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Menus, ShellAPI, DBCtrls;

const
  wm_IconMessage = wm_User;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    PopupMenu1: TPopupMenu;
    BoldTSofT1: TMenuItem;
    Close1: TMenuItem;
    Label2: TLabel;
    DBText1: TDBText;
    procedure Timer1Timer(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure BoldTSofT1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Label2Click(Sender: TObject);
  private
  Hour, Minute, Second: Word; {hora corrente}
XCenter, YCenter, Radius: Integer;
procedure IconTray (var Msg: TMessage);
  message wm_IconMessage;
    { Private declarations }
  public
  nid: TNotifyIconData;
  procedure DrawHand (XCenter, YCenter, Radius,
BackRadius: Integer; Angle: Real);
      { Public declarations }
  end;

var
  Form1: TForm1;
  H : HWnd;

implementation

{$R *.dfm}

procedure TForm1.Timer1Timer(Sender: TObject);
var
HSec: Word; {valor temporrio, no utilizado}
begin
DBText1.Caption:=TimeToStr(now);
{obtm a hora do sistema}
DecodeTime (Time, Hour, Minute, Second, HSec);
Refresh;
end;


procedure TForm1.FormPaint(Sender: TObject);
var
Angle: Real;
I, X, Y, Size: Integer;
begin
{calcula o centro do formulrio}
XCenter := ClientWidth div 2;
YCenter := ClientHeight div 2;
if XCenter > YCenter then
Radius := YCenter - 10
else
Radius := XCenter - 10;
{0. Desenha o marcador de horas}
Canvas.Pen.Color := clred;
Canvas.Brush.Color := clyellow;
Size := Radius div 50 + 1;
for I := 0 to 11 do
begin
Angle := 2 * Pi * I / 12;
X := XCenter - Round (Radius * Cos (Angle));
Y := YCenter - Round (Radius * Sin (Angle));
Canvas.Ellipse (X - Size, Y - Size, X +
Size, Y + Size);
end;

{1. Desenha o ponteiro dos minutos}
Canvas.Pen.Width := 2;
Canvas.Pen.Color := clWindow;
Angle := 2 * Pi * Minute / 60;
DrawHand (XCenter, YCenter, Radius * 90 div 100, 0, Angle);
{2. Desenha o ponteiro das horas: percentual dos minutos adicionado  hora para mover o ponteiro suavemente}
Angle := 2 * Pi * (Hour + Minute / 60) / 12;
DrawHand (XCenter, YCenter,
Radius * 70 div 100, 0, Angle);
{3. Desenha o ponteiro dos segundos}
Canvas.Pen.Width := 1;
Canvas.Pen.Color := clRed;
Angle := 2 * Pi * Second / 60;
DrawHand (XCenter, YCenter, Radius,
Radius * 30 div 100, Angle);
end;

procedure TForm1.DrawHand (XCenter, YCenter,
Radius, BackRadius: Integer; Angle: Real);
begin
Angle := (Angle + 3*Pi/2);
Canvas.MoveTo (
XCenter - Round (BackRadius * Cos (Angle)),
YCenter - Round (BackRadius * Sin (Angle)));
Canvas.LineTo (
XCenter + Round (Radius * Cos (Angle)),
YCenter + Round (Radius * Sin (Angle)));
end;



procedure TForm1.FormCreate(Sender: TObject);
begin
Timer1Timer (self);
Icon.Handle := LoadIcon (HInstance, 'MAINICON');
  // preenche os dados da estrutura NotifyIcon
  nid.cbSize := sizeof (nid);
  nid.wnd := Handle;
  nid.uID := 1; // Identificador do cone
  nid.uCallBAckMessage := wm_IconMessage;
  nid.hIcon := Icon.Handle;
  nid.szTip := 'BoldTSofT';
  nid.uFlags := nif_Message or
  nif_Icon or nif_Tip;
  Shell_NotifyIcon (NIM_ADD, @nid);
end;

procedure TForm1.IconTray (var Msg: TMessage);
var
  Pt: TPoint;
begin
  if Msg.lParam = wm_rbuttondown then
  begin
  GetCursorPos (Pt);
  SetForegroundWindow (Handle);
  PopupMenu1.Popup (Pt.x, Pt.y);
  end;
  end;
  
procedure TForm1.FormResize(Sender: TObject);
begin
Refresh;
end;

procedure TForm1.FormShow(Sender: TObject);
var
hR : THandle;
begin {cria uma Reigio elptica}
hR := CreateEllipticRgn(15,30,485,500);
SetWindowRgn(Handle,hR,True);
H := FindWindow(Nil,'Relogio');
if H <> 0 then ShowWindow(H,SW_HIDE);
end;

procedure TForm1.Close1Click(Sender: TObject);
begin
Form1.Close;
end;

procedure TForm1.BoldTSofT1Click(Sender: TObject);
begin
Showmessage('BoldTSofT  D+');
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
nid.uFlags := 0;
  Shell_NotifyIcon (NIM_DELETE, @nid);
end;

procedure TForm1.Label2Click(Sender: TObject);
begin
shellExecute(handle,'open','mailto:ivanboldt@ig.com.br','','',1);
end;

end.
